#!/usr/bin/env  python
__license__     = 'GPL v3'
__author__      = 'Lorenzo Vigentini'
__copyright__   = '2009, Lorenzo Vigentini <l.vigentini at gmail.com>'
__version__     = 'v1.01'
__date__        = '14, January 2010'
__description__ = 'PC Advisor delivers expert advice you can trust to business and home PC users who want to buy the best-value equipment and make the most out of the equipment they already own.'

'''
http://www.pcadvisor.co.uk/
'''

from calibre.web.feeds.news import BasicNewsRecipe

class pcAdvisor(BasicNewsRecipe):
    __author__    = 'Lorenzo Vigentini'
    description   = 'PC Advisor delivers expert advice you can trust to business and home PC users who want to buy the best-value equipment and make the most out of the equipment they already own.'

    cover_url      = 'http://media.pcadvisor.co.uk/images/spacer.gif'
    title          = 'Pc Advisor '
    publisher      = 'IDG Communication'
    category       = 'PC, computing, product reviews, UK'

    language       = 'en'
    encoding       = 'cp1252'
    timefmt        = '[%a, %d %b, %Y]'

    oldest_article        = 7
    max_articles_per_feed = 100
    summary_length         = 100
    use_embedded_content  = False
    recursion             = 10

    remove_javascript     = True
    no_stylesheets = True

    keep_only_tags     = [
                            dict(name='div', attrs={'id':'articlecontent'})
                        ]

    remove_tags        = [
                            dict(name='div', attrs={'id':['crosssitesignup','submitarticle','dontPrint','commentsForm','userReviewFormContainer','reevooContainerId']}),
                            dict(name='div', attrs={'class':['mpu','commentsContainer']}),
                            dict(name='p', attrs={'id':'articlePageList'}),
                            dict(name='div', attrs={'style':['margin: 0pt 10px 5px;','margin: 0pt 10px 5px;','MARGIN: 0px; WIDTH: 300px;']}),
                            dict(name='p', attrs={'class':['dontPrint','newsdate']}),
                            dict(name='h2', attrs={'class':'sectionTitle'}),
                            dict(name='a', attrs={'title':'Subscribe to PC Advisor'}),
                            dict(name='a', attrs={'name':'revooContent'}),
                            dict(name='img'),
                            {'name':['form','script','link']}
                        ]

    remove_tags_after = [
                            dict(name='p', attrs={'id':'crosssitesignup'})
                        ]

    def get_article_url(self, article):
        return article.get('guid',  None)

    feeds          = [
                       (u'News Headlines', u'http://www.pcadvisor.co.uk/rss/feeds/pcanews.xml'),
                       (u'Reviews', u'http://www.pcadvisor.co.uk/rss/feeds/pcareviews.xml'),
                       (u'New Products', u'http://www.pcadvisor.co.uk/rss/feeds/blog18.xml'),
                       (u'PC Advisor Blog', u'http://www.pcadvisor.co.uk/rss/feeds/blog4.xml'),
                       (u'Software', u'http://www.pcadvisor.co.uk/rss/feeds/pca-software.xml'),
                       (u'Photo and video', u'http://www.pcadvisor.co.uk/rss/feeds/pca-photo-video.xml'),
                       (u'Gadgets', u'http://www.pcadvisor.co.uk/rss/feeds/pca-gadgets.xml')
                     ]

    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''
	                   

    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		